/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.player;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.api.recipes.ChiselRecipe;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SkillType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

@ParametersAreNonnullByDefault
public class PlayerDataHandler
implements ICapabilitySerializable<NBTTagCompound>,
IPlayerData {
    public static final int MAX_INTOXICATED_TICKS = 36000;
    private final Map<String, Skill> skills;
    private final EntityPlayer player;
    private ItemStack harvestingTool;
    private long intoxicatedTime;
    private boolean hasBook;
    private ChiselRecipe.Mode chiselMode = ChiselRecipe.Mode.SMOOTH;

    public PlayerDataHandler(EntityPlayer player) {
        this.skills = SkillType.createSkillMap(this);
        this.player = player;
        this.harvestingTool = ItemStack.field_190927_a;
        this.hasBook = false;
        this.intoxicatedTime = 0L;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.skills.forEach((k, v) -> nbt.func_74782_a(k, v.serializeNBT()));
        nbt.func_74782_a("chiselMode", (NBTBase)new NBTTagByte((byte)this.chiselMode.ordinal()));
        nbt.func_74782_a("harvestingTool", (NBTBase)this.harvestingTool.serializeNBT());
        nbt.func_74757_a("hasBook", this.hasBook);
        nbt.func_74772_a("intoxicatedTime", this.intoxicatedTime);
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.skills.forEach((k, v) -> v.deserializeNBT((NBTBase)nbt.func_74775_l(k)));
            this.chiselMode = ChiselRecipe.Mode.valueOf(nbt.func_74771_c("chiselMode"));
            this.harvestingTool = new ItemStack(nbt.func_74775_l("harvestingTool"));
            this.hasBook = nbt.func_74767_n("hasBook");
            this.intoxicatedTime = nbt.func_74763_f("intoxicatedTime");
        }
    }

    @Override
    @Nullable
    public <S extends Skill> S getSkill(SkillType<S> skillType) {
        return (S)this.skills.get(skillType.getName());
    }

    @Override
    @Nonnull
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    @Nonnull
    public ItemStack getHarvestingTool() {
        return this.harvestingTool;
    }

    @Override
    public void setHarvestingTool(@Nonnull ItemStack stack) {
        this.harvestingTool = stack.func_77946_l();
    }

    @Override
    @Nonnull
    public ChiselRecipe.Mode getChiselMode() {
        return this.chiselMode;
    }

    @Override
    public void setChiselMode(ChiselRecipe.Mode chiselMode) {
        this.chiselMode = chiselMode;
    }

    @Override
    public void addIntoxicatedTime(long ticks) {
        long currentTicks = CalendarTFC.PLAYER_TIME.getTicks();
        if (this.intoxicatedTime < currentTicks) {
            this.intoxicatedTime = currentTicks;
        }
        this.intoxicatedTime += ticks;
        if (this.intoxicatedTime > currentTicks + 36000L) {
            this.intoxicatedTime = currentTicks + 36000L;
        }
    }

    @Override
    public long getIntoxicatedTime() {
        return Math.max(0L, this.intoxicatedTime - CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    public boolean hasBook() {
        return this.hasBook;
    }

    @Override
    public void setHasBook(boolean value) {
        this.hasBook = value;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityPlayerData.CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityPlayerData.CAPABILITY ? this : null);
    }
}

